using System;
using Server;
using Server.Network;

namespace Server.Items
{
	public enum TotemType
	{
		MagicArrow,
		Pacify,
		Healing
	}
   
   public class BaseTotem : Item
	{	
		private TotemType m_TotemType;
		private int m_Charges = 6;
		private Mobile m_Owner;
		private Timer m_Timer;

		[CommandProperty(AccessLevel.GameMaster)]
		public TotemType TotemTyp { get { return m_TotemType; } set { m_TotemType = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Charges { get { return m_Charges; } set { m_Charges = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public Mobile Owner { get { return m_Owner; } set { m_Owner = value; } }
      
		public BaseTotem( TotemType typ, int charges, Mobile owner ) : base( 13900 )
		{
         Name = "totem";
         Weight = 1.0;
			Hue = 0;
			Movable = false;
			
			m_TotemType = typ;
			m_Charges = charges;
			m_Owner = owner;
			
			m_Timer = new InternalTimer( this, m_Owner, m_Charges );
			m_Timer.Start();
		}
		
		public virtual void DoEffect( int count )
		{
      }
      
		public override void OnDoubleClick( Mobile from )
		{
			if ( m_Owner == from && from.InRange( this.GetWorldLocation(), 2 ) )
			{
				Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x3728, 8, 20, 5042 );
				Effects.PlaySound( Location, Map, 0x201 );
			   this.Delete();
         }
			else
				return;
		}
      
		public override void OnDelete()
		{
			if ( m_Timer != null )
            m_Timer.Stop();

			base.OnDelete();
		}

		public BaseTotem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			this.Delete();
		}
		
		private class InternalTimer : Timer
		{
			private BaseTotem m_Totem;
			private Mobile m_Owner;
			private int m_Count;

			public InternalTimer( BaseTotem totem, Mobile owner, int charges ) : base( TimeSpan.FromSeconds( 3.0 ), TimeSpan.FromSeconds( 3.0 ) )
			{
				m_Totem = totem;
				m_Owner = owner;
				m_Count = charges;
				Priority = TimerPriority.TwoFiftyMS;
			}

			protected override void OnTick() 
			{
				m_Count--;

				if ( m_Count < 1 || !m_Owner.Alive || m_Owner.Blessed || !m_Owner.InRange( m_Totem.GetWorldLocation(), 10 ) || m_Owner.NetState == null )
				{
					Stop();
					Effects.SendLocationParticles( EffectItem.Create( m_Totem.Location, m_Totem.Map, EffectItem.DefaultDuration ), 0x3728, 8, 20, 5042 );
					Effects.PlaySound( m_Totem.Location, m_Totem.Map, 0x201 );
					m_Totem.Delete();
				}
				else
				{
               m_Owner.RevealingAction();
               m_Totem.DoEffect( m_Count );
            }
			}
		}
	}
}